#include <iostream>
#include <vector>

using namespace std;

int xor_delilaca(const vector<int> &vec, const int &x)
{
    int val = 0;
    for (int i = 0; i < vec.size(); ++i)
      if (vec[i] <= x)
        val ^= vec[i];
    
    return val;
}

int xor_delilaca_manual(const vector<int> &vec, const int &x)
{
    int val = 0;
    for (int i = 1; i <= x; ++i)
      if (x % i == 0)
        val ^= i;
    
    return val;
}

int main(void)
{
    int n, k;
    cin >> n >> k;
    
    vector<int> d(k);
    for (int i = 0; i < k; ++i)
      cin >> d[i];
    
    for (int i = 0; i < k; ++i)
    {
        cout << xor_delilaca_manual(d, d[i]) << ' ';
    }
    
    return 0;
}